/* program to plot a spectra in graphics mode
 * written by:  Terry Dawson
 * date:        3rd October 1996
 *
 */

 #include <stdio.h>
 #include <graphics.h>
 #include <conio.h>

 main()
 {
	FILE *infile;
	float num, wavl[3000],refstd[3000], hiref, hiwave, maxx, maxy;
	float refl,trans, max_r, max_t;
	int i,j;
	int graphdriver = DETECT, graphmode;
	int xcoor,ycoor, refint;
	char *text="";

	initgraph(&graphdriver, &graphmode, "");
	setbkcolor(0);

	printf("PLOT.C - A plot of the LIBERTY.OUT spectra. \n\n");
	/* The following line contains the name of the file to plot */
	if ((infile = fopen("liberty.out","rt")) == NULL) {
		printf("Could not open input file!\n");
		exit(0);
		}
	rewind(infile);
	i=0;
	hiref=0;
	max_r=0;
	max_t=0;
	setcolor(14);
	/* read first line of text */
	fscanf(infile,"%s %s %s %s\n",text,text,text,text);
	printf("Reading predicted reflectance data...\n");
	moveto(50,400);
	while (!feof(infile)) {
	     fscanf(infile,"%f %f %f %f\n",&wavl[i],&refstd[i],&refl,&trans);
	     if (refstd[i] >= hiref) hiref=refstd[i]; /* setting for max ref */
	     if (refl >= max_r) max_r = refl;
	     if (trans >= max_t) max_t = trans;
	     xcoor=((wavl[i])-200)/4;
	     ycoor=(400-((refstd[i])*400));
	     putpixel(xcoor,ycoor,14);
	     putpixel(xcoor,(400-(refl*400)),12);
	     putpixel(xcoor,(400-(trans*400)),11);
	     /* lineto(xcoor,ycoor); */
	     i=i+1;
	}
	hiwave=wavl[i-1];
	maxx=(((wavl[i-1])-200)/4);
	maxy=(400-(hiref*400));
	setcolor(15);
	line(45,400,maxx,400); /* draw axis */
	line(50,405,50,maxy);
	line(50,maxy,45,maxy);
	line(maxx,400,maxx,405);
	outtextxy(8,260,"Refl");
	outtextxy(12,270,"(%)");
	outtextxy(250,410,"Wavelength (nm)");
	refint=1000*hiref; /* get value of hiref in % x10 */
	/* printf("%d",refint); */
	hiref=(refint);
	hiref=hiref/10;
	gcvt(hiref,4,text);
	outtextxy(12,maxy-3,text);
	gcvt(hiwave,5,text);
	outtextxy(maxx-15,410,text);
	outtextxy(38,410,"400");
	outtextxy(25,397,"0");
	/* print out legend */
	setcolor(14);
	gcvt(hiref,4,text);
	outtextxy(maxx-50,maxy-20,text);
	outtextxy(maxx-80,maxy-20,"R =");
	setcolor(12);
	max_r = max_r * 100;
        gcvt(max_r,4,text);
	outtextxy(maxx-50,maxy-5,text);
	outtextxy(maxx-80,maxy-5,"r =");
	setcolor(11);
	max_t = max_t * 100;
	gcvt(max_t,4,text);
	outtextxy(maxx-50,maxy+10,text);
	outtextxy(maxx-80,maxy+10,"t =");
	setcolor(15);
	outtextxy(maxx-80,maxy-40,"Max values");
	/* box it! */
	moveto(maxx-90,maxy-30);
	lineto(maxx+10,maxy-30);lineto(maxx+10,maxy+25);
	lineto(maxx-90,maxy+25);lineto(maxx-90,maxy-30);
	fclose(infile);
	getch();
	closegraph();
	printf("\nDone\n");
 }
